// Set up the environment
clear all
set maxvar 20000

// Read in the Wave 13 data
use "m_indresp.dta"

// Merge in Wave 12 variables on health conditions
merge 1:1 pidp using "l_indresp.dta", keepusing(pidp l_hcond*)
keep if _merge == 3
drop _merge


// Create an indicator of having high blood presure at Wave 12
gen l_high_bp = .
replace l_high_bp = 1 if l_hcondncode16 == 1 & l_hcondns16 == 1 // Code as 1 for continuing respondents with newly diagnosed high blood pressure who still had it
replace l_high_bp = 1 if l_hcondp16 == 1 // Code as 1 for continuing respondents who reported high blood presure before Wave 12 and still had it
replace l_high_bp = 1 if l_hcondcode16 == 1 & l_hconds16 == 1 // Code as 1 for new respondents who reported high blood pressure and still had it
replace l_high_bp = 0 if !(l_hcondncode16 == 1 & l_hcondns16 == 1) & l_hcondp16 != 1 & !(l_hcondcode16 == 1 & l_hconds16 == 1) // Code as 0 everyone who does not meet any of the above conditions


// Tabulate the variable indicating having high blood presure at Wave 12 against the Wave 13 m_prevhcondno16 variable
tab m_prevhcondno16 l_high_bp

// 268 respondents who had high blood pressure at Wave 12 are coded as inapplicable for the m_prevhcondno16 variable


